implementation module CMCombinators

import StdEnv
import StdiTasks


// Basic combinators
tryRepeat :: (Task (Maybe a)) -> Task a | iData a
tryRepeat taska = try taska return_V (tryRepeat taska) 

breakable :: (Task a) (a -> Task Void) -> Task Void | iData a
breakable taska taskfa = try (break taska)
                             taskfa
                             void                           
                           
try :: (Task (Maybe a)) (a -> Task b) (Task b) -> Task b | iData b
try taska taskfa taskb = taska =>> \x ->
                         case x of
                           Nothing -> taskb
                           Just x` -> taskfa x`
                           
break :: (Task a) -> Task (Maybe a) | iData a
break taska = (taska =>>
               return_V o Just) 
              -||- 
              (cancel #>>
               return_V Nothing)                
               
ok :: Task Void
ok = button "Ok" Void

cancel :: Task Void
cancel = button "Cancel" Void

void :: Task Void
void = return_V Void

editTaskSubmit :: a -> Task a | iData a
editTaskSubmit x = editTaskPred x (const (True, [])) <<@ Submit

derive gForm  Maybe
derive gUpd   Maybe
derive gParse Maybe
derive gPrint Maybe